# 메모리 관리 (Memory Management)
메모리는 CPU가 실행할 프로그램 코드와 데이터를 저장하는 물리 장치이며, `CPU 레지스터`, `캐시 메모리`, `메인 메모리`, `보조 기억 장치` 등 읽고 쓰는 속도와 용량에 따라 메모리 계층 구조를 이룬다.  

<br>

## 메인 메모리 (Main Memory / 주기억장치, RAM)
- CPU가 직접 접근하는 기억 장치이다.
- 현재 실행 중인 모든 프로세스의 코드와 데이터, 파일 블록 등이 저장된다.
- 프로세스가 정상적으로 실행되려면 프로그램이 메모리에 load 되어야 한다.
- 주소가 할당된 일련의 바이트들로 구성되어 있다.
- CPU는 레지스터가 가리키는 주소로 메모리에 접근하여 다음에 수행할 명령어를 가져온다. 필요한 데이터가 없으면 `MMU`를 통해 해당 데이터를 가져온다.

<br>

### MMU (Memory Management unit, 메모리 관리 장치)
- 논리 주소를 물리 주소로 변환한다.
- 프로세스가 CPU에서 수행되면서 생성하는 모든 주소에 대해 `base register`를 더해주어 물리 주소로 변롼한다.
- 메모리 보호나 캐시 관리 등 CPU가 메모리에 접근하는 것을 총 관리하는 하드웨어이다.
  - base register\*와 limit register\*를 이용하여 메모리를 보호한다.

<br>

_\*base register : 접근할 수 있는 물리적 주소의 최솟값_  
_\*limit register : 논리적 주소의 범위_  

<img width="600" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2FAxi6E%2FbtrfXzneVjm%2FWd9c3R2hRFtP1uupL6NTh1%2Fimg.png">

</br>

## 메모리 주소
- 메모리는 오직 주소를 이용해서만 접근되며, 주소는 다음 2가지 형태가 있다. 
  - **논리 주소** : 프로세스마다 독립적으로 가지는 주소 공간이며, 각 프로세스마다 0번지부터 시작한다. 프로세스 내에서 사용되는 코드와 데이터에 대한 주소이다. CPU가 생성한다.
  - **물리 주소** : 프로세스가 할당되는 하드웨어 메모리의 주소이다.
- 논리 주소가 물리 주소로 바뀌어 물리 메모리가 액세스 된다.

<br>

## Address Binding
어떤 프로그램을 어떤 물리적 주소에 `load` 할 지 결정하는 과정이다. `binding` 하는 시점에 따라 분류된다.  

<br>

### 1. Compile Time
- 컴파일 시 프로세스의 물리적 주소가 정해진다. 
- 메모리 내 프로세스 위치를 미리 알고있다면, 컴파일러가 해당 위치에 고정된 주소를 생성한다.
- 논리적 주소와 물리적 주소가 동일하다.

### 2. Load Time
- 메모리 내 프로세스의 위치를 알 수 없다면, 컴파일러는 `Relocatable Code`\*를 생성한다.
- 프로세스를 메모리에 load 하는 시점에 `Loader`가 물리적 주소를 결정한다.
- 논리 주소와 물리 주소가 다를 수 있다.

<br>

_\*Relocatable Code: 어느 위치에서나 수행 가능한 기계 언어 코드_  

### 3. Execution Time
- 프로세스 실행되면서 메모리 주소를 동적으로 변경하는 방법이다.
- 런타임 시 물리적 주소가 결정된다.
- 런타임 주소 할당은 **MMU**라는 장치를 사용해서 논리 주소를 물리 주소로 바꾼다.

<img width="600" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2FVXqac%2Fbtrf1h0DcjO%2Fz7U7zvjA3zN7r1cepDDCQ1%2Fimg.png">  

</br>

## 메모리 할당
- 메모리는 일반적으로 **커널 영역**과 **사용자 프로세스 영역**으로 나누어 사용한다.
- 다음은 **사용자 프로세스 영역**에 [메모리 할당](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/페이징%20&%20세그먼테이션(PDF).md)을 하는 두 가지 방법이다.
  - `Contiguous Allocation (연속적 할당)` : 프로세스들이 연속적인 메모리 공간을 차지한다.
  - `Noncontiguous Allocation (비연속적 할당)` : 프로세스들이 고정 크기의 블록으로 나뉘어 메모리에 순서 상관 없이 저장된다.

</br>

### 메모리 과할당 (over allocating)
- 실제 메모리의 사이즈보다 더 큰 사이즈의 메모리를 프로세스에 할당한 경우이다.
- 페이징 기법과 같은 메모리 관리로 사용자가 알지 못하도록 해야 하지만, page fault\*가 발생하여 메모리에 페이지를 올려야하는 경우에는 빈 프레임을 확보해야만 한다.
- 이때 쓰이는 방법이 **[페이지 교체 알고리즘](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/페이지%20교체%20알고리즘.md)** 과 **Swapping** 이다.

<br>

_\* page fault: 프로세스가 필요한 데이터나 코드가 메모리에 load 되어 있지 않아 페이지 테이블을 통해 해당 페이지를 메모리로 가져와야 하는 상황_

<br>

### Swapping

- 메모리는 크기가 제한적이기 때문에 프로세스를 디스크에 임시로 보내고 필요할 때 메모리로 다시 로드하는 경우가 발생한다.
- 이때 디스크로 보내는 작업을 `swap out`, 메모리로 다시 로드하는 작업을 `swap in` 이라고 한다.
- 보통 스케줄러를 통해 어떤 프로세스를 `swap in/out` 할 지 결정한다.
- `Compile Time Binding`과 `Load Time Binding`은 `swap in` 할 때 같은 메모리 위치로 load 해야한다. 
- `Execution Binding`의 경우는 주소 변환이 되기 때문에 빈 메모리 영역 어느 곳이든 load 할 수 있다.

</br>
 
## TLB (Translation Look-aside Buffer)
- TLB는 메모리 주소 변환을 위한 별도의 캐시 메모리로, [page table](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/페이징%20&%20세그먼테이션(PDF).md)에서 빈번히 참조되는 일부 엔트리를 캐싱한다.
- TLB는 key-value 쌍으로 데이터를 관리하며, key에는 page number, value에는 frame number가 대응된다.
- 따라서 CPU는 TLB를 page table 보다 먼저 참조하여, 원하는 페이지가 있다면 바로 frame number를 얻을 수 있다.

<img width="600" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2FHn5LS%2FbtrgbJWogu4%2FroXaWbW7e6ZWojG4KZSnLk%2Fimg.png">

</br>

----
## Referance
- https://rebro.kr/178
- https://velog.io/@jiyaho/CS-운영체제-메모리-관리
- 명품 운영체제

